<?php
// This file was auto-generated from sdk-root/src/data/iot-managed-integrations/2025-03-03/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2025-03-03', 'auth' => [ 'aws.auth#sigv4', ], 'endpointPrefix' => 'api.iotmanagedintegrations', 'protocol' => 'rest-json', 'protocols' => [ 'rest-json', ], 'serviceFullName' => 'Managed integrations for AWS IoT Device Management', 'serviceId' => 'IoT Managed Integrations', 'signatureVersion' => 'v4', 'signingName' => 'iotmanagedintegrations', 'uid' => 'iot-managed-integrations-2025-03-03', ], 'operations' => [ 'CreateCredentialLocker' => [ 'name' => 'CreateCredentialLocker', 'http' => [ 'method' => 'POST', 'requestUri' => '/credential-lockers', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateCredentialLockerRequest', ], 'output' => [ 'shape' => 'CreateCredentialLockerResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'CreateDestination' => [ 'name' => 'CreateDestination', 'http' => [ 'method' => 'POST', 'requestUri' => '/destinations', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateDestinationRequest', ], 'output' => [ 'shape' => 'CreateDestinationResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'CreateEventLogConfiguration' => [ 'name' => 'CreateEventLogConfiguration', 'http' => [ 'method' => 'POST', 'requestUri' => '/event-log-configurations', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateEventLogConfigurationRequest', ], 'output' => [ 'shape' => 'CreateEventLogConfigurationResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ServiceQuotaExceededException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'CreateManagedThing' => [ 'name' => 'CreateManagedThing', 'http' => [ 'method' => 'POST', 'requestUri' => '/managed-things', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateManagedThingRequest', ], 'output' => [ 'shape' => 'CreateManagedThingResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'CreateNotificationConfiguration' => [ 'name' => 'CreateNotificationConfiguration', 'http' => [ 'method' => 'POST', 'requestUri' => '/notification-configurations', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateNotificationConfigurationRequest', ], 'output' => [ 'shape' => 'CreateNotificationConfigurationResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'CreateOtaTask' => [ 'name' => 'CreateOtaTask', 'http' => [ 'method' => 'POST', 'requestUri' => '/ota-tasks', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateOtaTaskRequest', ], 'output' => [ 'shape' => 'CreateOtaTaskResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'CreateOtaTaskConfiguration' => [ 'name' => 'CreateOtaTaskConfiguration', 'http' => [ 'method' => 'POST', 'requestUri' => '/ota-task-configurations', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateOtaTaskConfigurationRequest', ], 'output' => [ 'shape' => 'CreateOtaTaskConfigurationResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'CreateProvisioningProfile' => [ 'name' => 'CreateProvisioningProfile', 'http' => [ 'method' => 'POST', 'requestUri' => '/provisioning-profiles', 'responseCode' => 201, ], 'input' => [ 'shape' => 'CreateProvisioningProfileRequest', ], 'output' => [ 'shape' => 'CreateProvisioningProfileResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'DeleteCredentialLocker' => [ 'name' => 'DeleteCredentialLocker', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/credential-lockers/{Identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteCredentialLockerRequest', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], 'idempotent' => true, ], 'DeleteDestination' => [ 'name' => 'DeleteDestination', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/destinations/{Name}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteDestinationRequest', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], 'idempotent' => true, ], 'DeleteEventLogConfiguration' => [ 'name' => 'DeleteEventLogConfiguration', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/event-log-configurations/{Id}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteEventLogConfigurationRequest', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], 'idempotent' => true, ], 'DeleteManagedThing' => [ 'name' => 'DeleteManagedThing', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/managed-things/{Identifier}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteManagedThingRequest', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], 'idempotent' => true, ], 'DeleteNotificationConfiguration' => [ 'name' => 'DeleteNotificationConfiguration', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/notification-configurations/{EventType}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteNotificationConfigurationRequest', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], 'idempotent' => true, ], 'DeleteOtaTask' => [ 'name' => 'DeleteOtaTask', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/ota-tasks/{Identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteOtaTaskRequest', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], 'idempotent' => true, ], 'DeleteOtaTaskConfiguration' => [ 'name' => 'DeleteOtaTaskConfiguration', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/ota-task-configurations/{Identifier}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'DeleteOtaTaskConfigurationRequest', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], 'idempotent' => true, ], 'DeleteProvisioningProfile' => [ 'name' => 'DeleteProvisioningProfile', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/provisioning-profiles/{Identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'DeleteProvisioningProfileRequest', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], 'idempotent' => true, ], 'GetCredentialLocker' => [ 'name' => 'GetCredentialLocker', 'http' => [ 'method' => 'GET', 'requestUri' => '/credential-lockers/{Identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetCredentialLockerRequest', ], 'output' => [ 'shape' => 'GetCredentialLockerResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetCustomEndpoint' => [ 'name' => 'GetCustomEndpoint', 'http' => [ 'method' => 'GET', 'requestUri' => '/custom-endpoint', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetCustomEndpointRequest', ], 'output' => [ 'shape' => 'GetCustomEndpointResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetDefaultEncryptionConfiguration' => [ 'name' => 'GetDefaultEncryptionConfiguration', 'http' => [ 'method' => 'GET', 'requestUri' => '/configuration/account/encryption', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetDefaultEncryptionConfigurationRequest', ], 'output' => [ 'shape' => 'GetDefaultEncryptionConfigurationResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalFailureException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetDestination' => [ 'name' => 'GetDestination', 'http' => [ 'method' => 'GET', 'requestUri' => '/destinations/{Name}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetDestinationRequest', ], 'output' => [ 'shape' => 'GetDestinationResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetDeviceDiscovery' => [ 'name' => 'GetDeviceDiscovery', 'http' => [ 'method' => 'GET', 'requestUri' => '/device-discoveries/{Identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetDeviceDiscoveryRequest', ], 'output' => [ 'shape' => 'GetDeviceDiscoveryResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetEventLogConfiguration' => [ 'name' => 'GetEventLogConfiguration', 'http' => [ 'method' => 'GET', 'requestUri' => '/event-log-configurations/{Id}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetEventLogConfigurationRequest', ], 'output' => [ 'shape' => 'GetEventLogConfigurationResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetHubConfiguration' => [ 'name' => 'GetHubConfiguration', 'http' => [ 'method' => 'GET', 'requestUri' => '/hub-configuration', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetHubConfigurationRequest', ], 'output' => [ 'shape' => 'GetHubConfigurationResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetManagedThing' => [ 'name' => 'GetManagedThing', 'http' => [ 'method' => 'GET', 'requestUri' => '/managed-things/{Identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetManagedThingRequest', ], 'output' => [ 'shape' => 'GetManagedThingResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetManagedThingCapabilities' => [ 'name' => 'GetManagedThingCapabilities', 'http' => [ 'method' => 'GET', 'requestUri' => '/managed-things-capabilities/{Identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetManagedThingCapabilitiesRequest', ], 'output' => [ 'shape' => 'GetManagedThingCapabilitiesResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetManagedThingConnectivityData' => [ 'name' => 'GetManagedThingConnectivityData', 'http' => [ 'method' => 'POST', 'requestUri' => '/managed-things-connectivity-data/{Identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetManagedThingConnectivityDataRequest', ], 'output' => [ 'shape' => 'GetManagedThingConnectivityDataResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetManagedThingMetaData' => [ 'name' => 'GetManagedThingMetaData', 'http' => [ 'method' => 'GET', 'requestUri' => '/managed-things-metadata/{Identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetManagedThingMetaDataRequest', ], 'output' => [ 'shape' => 'GetManagedThingMetaDataResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetManagedThingState' => [ 'name' => 'GetManagedThingState', 'http' => [ 'method' => 'GET', 'requestUri' => '/managed-thing-states/{ManagedThingId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetManagedThingStateRequest', ], 'output' => [ 'shape' => 'GetManagedThingStateResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalFailureException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetNotificationConfiguration' => [ 'name' => 'GetNotificationConfiguration', 'http' => [ 'method' => 'GET', 'requestUri' => '/notification-configurations/{EventType}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetNotificationConfigurationRequest', ], 'output' => [ 'shape' => 'GetNotificationConfigurationResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetOtaTask' => [ 'name' => 'GetOtaTask', 'http' => [ 'method' => 'GET', 'requestUri' => '/ota-tasks/{Identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetOtaTaskRequest', ], 'output' => [ 'shape' => 'GetOtaTaskResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetOtaTaskConfiguration' => [ 'name' => 'GetOtaTaskConfiguration', 'http' => [ 'method' => 'GET', 'requestUri' => '/ota-task-configurations/{Identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetOtaTaskConfigurationRequest', ], 'output' => [ 'shape' => 'GetOtaTaskConfigurationResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetProvisioningProfile' => [ 'name' => 'GetProvisioningProfile', 'http' => [ 'method' => 'GET', 'requestUri' => '/provisioning-profiles/{Identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetProvisioningProfileRequest', ], 'output' => [ 'shape' => 'GetProvisioningProfileResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetRuntimeLogConfiguration' => [ 'name' => 'GetRuntimeLogConfiguration', 'http' => [ 'method' => 'GET', 'requestUri' => '/runtime-log-configurations/{ManagedThingId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetRuntimeLogConfigurationRequest', ], 'output' => [ 'shape' => 'GetRuntimeLogConfigurationResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'GetSchemaVersion' => [ 'name' => 'GetSchemaVersion', 'http' => [ 'method' => 'GET', 'requestUri' => '/schema-versions/{Type}/{SchemaVersionedId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'GetSchemaVersionRequest', ], 'output' => [ 'shape' => 'GetSchemaVersionResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListCredentialLockers' => [ 'name' => 'ListCredentialLockers', 'http' => [ 'method' => 'GET', 'requestUri' => '/credential-lockers', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListCredentialLockersRequest', ], 'output' => [ 'shape' => 'ListCredentialLockersResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListDestinations' => [ 'name' => 'ListDestinations', 'http' => [ 'method' => 'GET', 'requestUri' => '/destinations', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListDestinationsRequest', ], 'output' => [ 'shape' => 'ListDestinationsResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListEventLogConfigurations' => [ 'name' => 'ListEventLogConfigurations', 'http' => [ 'method' => 'GET', 'requestUri' => '/event-log-configurations', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListEventLogConfigurationsRequest', ], 'output' => [ 'shape' => 'ListEventLogConfigurationsResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListManagedThingSchemas' => [ 'name' => 'ListManagedThingSchemas', 'http' => [ 'method' => 'GET', 'requestUri' => '/managed-thing-schemas/{Identifier}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListManagedThingSchemasRequest', ], 'output' => [ 'shape' => 'ListManagedThingSchemasResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListManagedThings' => [ 'name' => 'ListManagedThings', 'http' => [ 'method' => 'GET', 'requestUri' => '/managed-things', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListManagedThingsRequest', ], 'output' => [ 'shape' => 'ListManagedThingsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListNotificationConfigurations' => [ 'name' => 'ListNotificationConfigurations', 'http' => [ 'method' => 'GET', 'requestUri' => '/notification-configurations', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListNotificationConfigurationsRequest', ], 'output' => [ 'shape' => 'ListNotificationConfigurationsResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListOtaTaskConfigurations' => [ 'name' => 'ListOtaTaskConfigurations', 'http' => [ 'method' => 'GET', 'requestUri' => '/ota-task-configurations', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListOtaTaskConfigurationsRequest', ], 'output' => [ 'shape' => 'ListOtaTaskConfigurationsResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListOtaTaskExecutions' => [ 'name' => 'ListOtaTaskExecutions', 'http' => [ 'method' => 'GET', 'requestUri' => '/ota-tasks/{Identifier}/devices', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListOtaTaskExecutionsRequest', ], 'output' => [ 'shape' => 'ListOtaTaskExecutionsResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListOtaTasks' => [ 'name' => 'ListOtaTasks', 'http' => [ 'method' => 'GET', 'requestUri' => '/ota-tasks', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListOtaTasksRequest', ], 'output' => [ 'shape' => 'ListOtaTasksResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListProvisioningProfiles' => [ 'name' => 'ListProvisioningProfiles', 'http' => [ 'method' => 'GET', 'requestUri' => '/provisioning-profiles', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListProvisioningProfilesRequest', ], 'output' => [ 'shape' => 'ListProvisioningProfilesResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ListSchemaVersions' => [ 'name' => 'ListSchemaVersions', 'http' => [ 'method' => 'GET', 'requestUri' => '/schema-versions/{Type}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ListSchemaVersionsRequest', ], 'output' => [ 'shape' => 'ListSchemaVersionsResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'PutDefaultEncryptionConfiguration' => [ 'name' => 'PutDefaultEncryptionConfiguration', 'http' => [ 'method' => 'POST', 'requestUri' => '/configuration/account/encryption', 'responseCode' => 201, ], 'input' => [ 'shape' => 'PutDefaultEncryptionConfigurationRequest', ], 'output' => [ 'shape' => 'PutDefaultEncryptionConfigurationResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalFailureException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ThrottlingException', ], [ 'shape' => 'ResourceNotFoundException', ], ], ], 'PutHubConfiguration' => [ 'name' => 'PutHubConfiguration', 'http' => [ 'method' => 'PUT', 'requestUri' => '/hub-configuration', 'responseCode' => 201, ], 'input' => [ 'shape' => 'PutHubConfigurationRequest', ], 'output' => [ 'shape' => 'PutHubConfigurationResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], 'idempotent' => true, ], 'PutRuntimeLogConfiguration' => [ 'name' => 'PutRuntimeLogConfiguration', 'http' => [ 'method' => 'PUT', 'requestUri' => '/runtime-log-configurations/{ManagedThingId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'PutRuntimeLogConfigurationRequest', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], 'idempotent' => true, ], 'RegisterCustomEndpoint' => [ 'name' => 'RegisterCustomEndpoint', 'http' => [ 'method' => 'POST', 'requestUri' => '/custom-endpoint', 'responseCode' => 201, ], 'input' => [ 'shape' => 'RegisterCustomEndpointRequest', ], 'output' => [ 'shape' => 'RegisterCustomEndpointResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'ResetRuntimeLogConfiguration' => [ 'name' => 'ResetRuntimeLogConfiguration', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/runtime-log-configurations/{ManagedThingId}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'ResetRuntimeLogConfigurationRequest', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], 'idempotent' => true, ], 'SendManagedThingCommand' => [ 'name' => 'SendManagedThingCommand', 'http' => [ 'method' => 'POST', 'requestUri' => '/managed-things-command/{ManagedThingId}', 'responseCode' => 202, ], 'input' => [ 'shape' => 'SendManagedThingCommandRequest', ], 'output' => [ 'shape' => 'SendManagedThingCommandResponse', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'StartDeviceDiscovery' => [ 'name' => 'StartDeviceDiscovery', 'http' => [ 'method' => 'POST', 'requestUri' => '/device-discoveries', 'responseCode' => 201, ], 'input' => [ 'shape' => 'StartDeviceDiscoveryRequest', ], 'output' => [ 'shape' => 'StartDeviceDiscoveryResponse', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], ], 'UpdateDestination' => [ 'name' => 'UpdateDestination', 'http' => [ 'method' => 'PUT', 'requestUri' => '/destinations/{Name}', 'responseCode' => 201, ], 'input' => [ 'shape' => 'UpdateDestinationRequest', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], 'idempotent' => true, ], 'UpdateEventLogConfiguration' => [ 'name' => 'UpdateEventLogConfiguration', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/event-log-configurations/{Id}', 'responseCode' => 200, ], 'input' => [ 'shape' => 'UpdateEventLogConfigurationRequest', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], 'idempotent' => true, ], 'UpdateManagedThing' => [ 'name' => 'UpdateManagedThing', 'http' => [ 'method' => 'PUT', 'requestUri' => '/managed-things/{Identifier}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'UpdateManagedThingRequest', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'UnauthorizedException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'ServiceUnavailableException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], 'idempotent' => true, ], 'UpdateNotificationConfiguration' => [ 'name' => 'UpdateNotificationConfiguration', 'http' => [ 'method' => 'PUT', 'requestUri' => '/notification-configurations/{EventType}', 'responseCode' => 201, ], 'input' => [ 'shape' => 'UpdateNotificationConfigurationRequest', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], 'idempotent' => true, ], 'UpdateOtaTask' => [ 'name' => 'UpdateOtaTask', 'http' => [ 'method' => 'PUT', 'requestUri' => '/ota-tasks/{Identifier}', 'responseCode' => 204, ], 'input' => [ 'shape' => 'UpdateOtaTaskRequest', ], 'errors' => [ [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'ThrottlingException', ], ], 'idempotent' => true, ], ], 'shapes' => [ 'AbortConfigCriteria' => [ 'type' => 'structure', 'members' => [ 'Action' => [ 'shape' => 'AbortCriteriaAction', ], 'FailureType' => [ 'shape' => 'AbortCriteriaFailureType', ], 'MinNumberOfExecutedThings' => [ 'shape' => 'MinNumberOfExecutedThings', ], 'ThresholdPercentage' => [ 'shape' => 'ThresholdPercentage', ], ], ], 'AbortConfigCriteriaList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AbortConfigCriteria', ], ], 'AbortCriteriaAction' => [ 'type' => 'string', 'enum' => [ 'CANCEL', ], ], 'AbortCriteriaFailureType' => [ 'type' => 'string', 'enum' => [ 'FAILED', 'REJECTED', 'TIMED_OUT', 'ALL', ], ], 'AccessDeniedException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 403, 'senderFault' => true, ], 'exception' => true, ], 'ActionName' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[/a-zA-Z0-9\\._ ]+', ], 'ActionReference' => [ 'type' => 'string', 'pattern' => '[a-zA-Z.]+', ], 'ActionTraceId' => [ 'type' => 'string', 'max' => 20, 'min' => 16, 'pattern' => '[a-zA-Z0-9]+=(?:_[0-9]+)?', ], 'AdvertisedProductId' => [ 'type' => 'string', 'max' => 5, 'min' => 5, 'pattern' => '([A-Za-z0-9!#$%&()*\\+\\-;<=>?@^_`{|}~])+', ], 'AttributeName' => [ 'type' => 'string', 'max' => 128, 'min' => 0, 'pattern' => '.*[a-zA-Z0-9_.,@/:#-]+.*', ], 'AttributeValue' => [ 'type' => 'string', 'max' => 800, 'min' => 0, 'pattern' => '.*[a-zA-Z0-9_.,@/:#-]*.*', ], 'AuthMaterialString' => [ 'type' => 'string', 'max' => 512, 'min' => 1, 'pattern' => '[0-9A-Za-z!#$%&()*\\+\\-;<=>?@^_`{|}~\\/: ]+', 'sensitive' => true, ], 'AuthMaterialType' => [ 'type' => 'string', 'enum' => [ 'WIFI_SETUP_QR_BAR_CODE', 'ZWAVE_QR_BAR_CODE', 'ZIGBEE_QR_BAR_CODE', ], ], 'BaseRatePerMinute' => [ 'type' => 'integer', 'box' => true, 'max' => 100, 'min' => 1, ], 'Boolean' => [ 'type' => 'boolean', 'box' => true, ], 'Brand' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[A-Za-z0-9-_ ]+', 'sensitive' => true, ], 'CaCertificate' => [ 'type' => 'string', 'pattern' => '-----BEGIN CERTIFICATE-----.*(.|\\n)*-----END CERTIFICATE-----\\n?', 'sensitive' => true, ], 'Capabilities' => [ 'type' => 'string', 'max' => 65535, 'min' => 1, 'pattern' => '[a-zA-Z0-9\\s\'\\x{0022},.:\\\\\\/{$}\\[\\]=_\\-\\+]+', ], 'CapabilityAction' => [ 'type' => 'structure', 'required' => [ 'name', ], 'members' => [ 'name' => [ 'shape' => 'CapabilityActionName', ], 'ref' => [ 'shape' => 'ActionReference', ], 'actionTraceId' => [ 'shape' => 'ActionTraceId', ], 'parameters' => [ 'shape' => 'CapabilityProperties', ], ], ], 'CapabilityActionName' => [ 'type' => 'string', 'pattern' => '[/a-zA-Z]+', ], 'CapabilityActions' => [ 'type' => 'list', 'member' => [ 'shape' => 'CapabilityAction', ], 'max' => 5, 'min' => 1, ], 'CapabilityId' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[a-zA-Z0-9./]+(@\\d+\\.\\d+)?', ], 'CapabilityName' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[/a-zA-Z0-9\\._ ]+', ], 'CapabilityProperties' => [ 'type' => 'structure', 'members' => [], 'document' => true, 'sensitive' => true, ], 'CapabilityReport' => [ 'type' => 'structure', 'required' => [ 'version', 'endpoints', ], 'members' => [ 'version' => [ 'shape' => 'CapabilityReportVersion', ], 'nodeId' => [ 'shape' => 'NodeId', ], 'endpoints' => [ 'shape' => 'CapabilityReportEndpoints', ], ], ], 'CapabilityReportActions' => [ 'type' => 'list', 'member' => [ 'shape' => 'ActionName', ], 'max' => 100, 'min' => 0, ], 'CapabilityReportCapabilities' => [ 'type' => 'list', 'member' => [ 'shape' => 'CapabilityReportCapability', ], 'max' => 50, 'min' => 0, ], 'CapabilityReportCapability' => [ 'type' => 'structure', 'required' => [ 'id', 'name', 'version', 'properties', 'actions', 'events', ], 'members' => [ 'id' => [ 'shape' => 'SchemaVersionedId', ], 'name' => [ 'shape' => 'CapabilityName', ], 'version' => [ 'shape' => 'CapabilityVersion', ], 'properties' => [ 'shape' => 'CapabilityReportProperties', ], 'actions' => [ 'shape' => 'CapabilityReportActions', ], 'events' => [ 'shape' => 'CapabilityReportEvents', ], ], ], 'CapabilityReportEndpoint' => [ 'type' => 'structure', 'required' => [ 'id', 'deviceTypes', 'capabilities', ], 'members' => [ 'id' => [ 'shape' => 'EndpointId', ], 'deviceTypes' => [ 'shape' => 'DeviceTypes', ], 'capabilities' => [ 'shape' => 'CapabilityReportCapabilities', ], ], ], 'CapabilityReportEndpoints' => [ 'type' => 'list', 'member' => [ 'shape' => 'CapabilityReportEndpoint', ], 'max' => 50, 'min' => 0, ], 'CapabilityReportEvents' => [ 'type' => 'list', 'member' => [ 'shape' => 'EventName', ], 'max' => 100, 'min' => 0, ], 'CapabilityReportProperties' => [ 'type' => 'list', 'member' => [ 'shape' => 'PropertyName', ], 'max' => 100, 'min' => 0, ], 'CapabilityReportVersion' => [ 'type' => 'string', 'max' => 10, 'min' => 1, 'pattern' => '1\\.0\\.0', ], 'CapabilityVersion' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '(0|[1-9][0-9]*)', ], 'ClaimCertificate' => [ 'type' => 'string', 'sensitive' => true, ], 'ClaimCertificatePrivateKey' => [ 'type' => 'string', 'sensitive' => true, ], 'Classification' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'sensitive' => true, ], 'ClientToken' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[a-zA-Z0-9=_-]+', ], 'CommandCapabilities' => [ 'type' => 'list', 'member' => [ 'shape' => 'CommandCapability', ], 'max' => 5, 'min' => 1, ], 'CommandCapability' => [ 'type' => 'structure', 'required' => [ 'id', 'name', 'version', 'actions', ], 'members' => [ 'id' => [ 'shape' => 'SchemaVersionedId', ], 'name' => [ 'shape' => 'CapabilityName', ], 'version' => [ 'shape' => 'CapabilityVersion', ], 'actions' => [ 'shape' => 'CapabilityActions', ], ], ], 'CommandEndpoint' => [ 'type' => 'structure', 'required' => [ 'endpointId', 'capabilities', ], 'members' => [ 'endpointId' => [ 'shape' => 'EndpointId', ], 'capabilities' => [ 'shape' => 'CommandCapabilities', ], ], ], 'CommandEndpoints' => [ 'type' => 'list', 'member' => [ 'shape' => 'CommandEndpoint', ], 'max' => 5, 'min' => 1, ], 'ConfigurationError' => [ 'type' => 'structure', 'members' => [ 'code' => [ 'shape' => 'ConfigurationErrorCode', ], 'message' => [ 'shape' => 'ConfigurationErrorMessage', ], ], ], 'ConfigurationErrorCode' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '[a-zA-Z0-9_-]+', ], 'ConfigurationErrorMessage' => [ 'type' => 'string', 'max' => 65535, 'min' => 1, 'pattern' => '[a-zA-Z0-9\\-._,]+', ], 'ConfigurationState' => [ 'type' => 'string', 'enum' => [ 'ENABLED', 'UPDATE_IN_PROGRESS', 'UPDATE_FAILED', ], ], 'ConfigurationStatus' => [ 'type' => 'structure', 'required' => [ 'state', ], 'members' => [ 'error' => [ 'shape' => 'ConfigurationError', ], 'state' => [ 'shape' => 'ConfigurationState', ], ], ], 'ConflictException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 409, 'senderFault' => true, ], 'exception' => true, ], 'ConnectivityStatus' => [ 'type' => 'boolean', 'box' => true, ], 'ConnectivityTimestamp' => [ 'type' => 'timestamp', ], 'ConnectorAssociationId' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[0-9a-zA-Z]+', ], 'ConnectorDeviceId' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '[a-zA-Z0-9_.,@-]+', 'sensitive' => true, ], 'ConnectorPolicyId' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[A-Za-z0-9-_]+', ], 'CreateCredentialLockerRequest' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'CredentialLockerName', ], 'ClientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'Tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateCredentialLockerResponse' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'CredentialLockerId', ], 'Arn' => [ 'shape' => 'CredentialLockerArn', ], 'CreatedAt' => [ 'shape' => 'CredentialLockerCreatedAt', ], ], ], 'CreateDestinationRequest' => [ 'type' => 'structure', 'required' => [ 'DeliveryDestinationArn', 'DeliveryDestinationType', 'Name', 'RoleArn', ], 'members' => [ 'DeliveryDestinationArn' => [ 'shape' => 'DeliveryDestinationArn', ], 'DeliveryDestinationType' => [ 'shape' => 'DeliveryDestinationType', ], 'Name' => [ 'shape' => 'DestinationName', ], 'RoleArn' => [ 'shape' => 'DeliveryDestinationRoleArn', ], 'ClientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'Description' => [ 'shape' => 'DestinationDescription', ], 'Tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateDestinationResponse' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'DestinationName', ], ], ], 'CreateEventLogConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'ResourceType', 'EventLogLevel', ], 'members' => [ 'ResourceType' => [ 'shape' => 'SmartHomeResourceType', ], 'ResourceId' => [ 'shape' => 'SmartHomeResourceId', ], 'EventLogLevel' => [ 'shape' => 'LogLevel', ], 'ClientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'CreateEventLogConfigurationResponse' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'LogConfigurationId', ], ], ], 'CreateManagedThingRequest' => [ 'type' => 'structure', 'required' => [ 'Role', 'AuthenticationMaterial', 'AuthenticationMaterialType', ], 'members' => [ 'Role' => [ 'shape' => 'Role', ], 'Owner' => [ 'shape' => 'Owner', ], 'CredentialLockerId' => [ 'shape' => 'CredentialLockerId', ], 'AuthenticationMaterial' => [ 'shape' => 'AuthMaterialString', ], 'AuthenticationMaterialType' => [ 'shape' => 'AuthMaterialType', ], 'SerialNumber' => [ 'shape' => 'SerialNumber', ], 'Brand' => [ 'shape' => 'Brand', ], 'Model' => [ 'shape' => 'Model', ], 'Name' => [ 'shape' => 'Name', ], 'CapabilityReport' => [ 'shape' => 'CapabilityReport', ], 'Capabilities' => [ 'shape' => 'Capabilities', ], 'ClientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'Classification' => [ 'shape' => 'Classification', ], 'Tags' => [ 'shape' => 'TagsMap', ], 'MetaData' => [ 'shape' => 'MetaData', ], ], ], 'CreateManagedThingResponse' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'ManagedThingId', ], 'Arn' => [ 'shape' => 'ManagedThingArn', ], 'CreatedAt' => [ 'shape' => 'CreatedAt', ], ], ], 'CreateNotificationConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'EventType', 'DestinationName', ], 'members' => [ 'EventType' => [ 'shape' => 'EventType', ], 'DestinationName' => [ 'shape' => 'DestinationName', ], 'ClientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'Tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateNotificationConfigurationResponse' => [ 'type' => 'structure', 'members' => [ 'EventType' => [ 'shape' => 'EventType', ], ], ], 'CreateOtaTaskConfigurationRequest' => [ 'type' => 'structure', 'members' => [ 'Description' => [ 'shape' => 'OtaDescription', ], 'Name' => [ 'shape' => 'OtaTaskConfigurationName', ], 'PushConfig' => [ 'shape' => 'PushConfig', ], 'ClientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], ], ], 'CreateOtaTaskConfigurationResponse' => [ 'type' => 'structure', 'members' => [ 'TaskConfigurationId' => [ 'shape' => 'OtaTaskConfigurationId', ], ], ], 'CreateOtaTaskRequest' => [ 'type' => 'structure', 'required' => [ 'S3Url', 'OtaType', ], 'members' => [ 'Description' => [ 'shape' => 'OtaDescription', ], 'S3Url' => [ 'shape' => 'S3Url', ], 'Protocol' => [ 'shape' => 'OtaProtocol', ], 'Target' => [ 'shape' => 'Target', ], 'TaskConfigurationId' => [ 'shape' => 'OtaTaskConfigurationId', ], 'OtaMechanism' => [ 'shape' => 'OtaMechanism', ], 'OtaType' => [ 'shape' => 'OtaType', ], 'OtaTargetQueryString' => [ 'shape' => 'OtaTargetQueryString', ], 'ClientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'OtaSchedulingConfig' => [ 'shape' => 'OtaTaskSchedulingConfig', ], 'OtaTaskExecutionRetryConfig' => [ 'shape' => 'OtaTaskExecutionRetryConfig', ], 'Tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateOtaTaskResponse' => [ 'type' => 'structure', 'members' => [ 'TaskId' => [ 'shape' => 'OtaTaskId', ], 'TaskArn' => [ 'shape' => 'OtaTaskArn', ], 'Description' => [ 'shape' => 'OtaDescription', ], ], ], 'CreateProvisioningProfileRequest' => [ 'type' => 'structure', 'required' => [ 'ProvisioningType', ], 'members' => [ 'ProvisioningType' => [ 'shape' => 'ProvisioningType', ], 'CaCertificate' => [ 'shape' => 'CaCertificate', ], 'Name' => [ 'shape' => 'ProvisioningProfileName', ], 'ClientToken' => [ 'shape' => 'ClientToken', 'idempotencyToken' => true, ], 'Tags' => [ 'shape' => 'TagsMap', ], ], ], 'CreateProvisioningProfileResponse' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'ProvisioningProfileArn', ], 'Name' => [ 'shape' => 'ProvisioningProfileName', ], 'ProvisioningType' => [ 'shape' => 'ProvisioningType', ], 'Id' => [ 'shape' => 'ProvisioningProfileId', ], 'ClaimCertificate' => [ 'shape' => 'ClaimCertificate', ], 'ClaimCertificatePrivateKey' => [ 'shape' => 'ClaimCertificatePrivateKey', ], ], ], 'CreatedAt' => [ 'type' => 'timestamp', ], 'CredentialLockerArn' => [ 'type' => 'string', 'max' => 1011, 'min' => 32, 'pattern' => 'arn:aws:iotmanagedintegrations:[0-9a-zA-Z-]+:[0-9]+:credential-locker/[0-9a-zA-Z]+', ], 'CredentialLockerCreatedAt' => [ 'type' => 'timestamp', ], 'CredentialLockerId' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[a-zA-Z0-9]*', ], 'CredentialLockerListDefinition' => [ 'type' => 'list', 'member' => [ 'shape' => 'CredentialLockerSummary', ], ], 'CredentialLockerName' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[A-Za-z0-9-_ ]+', 'sensitive' => true, ], 'CredentialLockerSummary' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'CredentialLockerId', ], 'Arn' => [ 'shape' => 'CredentialLockerArn', ], 'Name' => [ 'shape' => 'CredentialLockerName', ], 'CreatedAt' => [ 'shape' => 'CredentialLockerCreatedAt', ], ], ], 'DeleteCredentialLockerRequest' => [ 'type' => 'structure', 'required' => [ 'Identifier', ], 'members' => [ 'Identifier' => [ 'shape' => 'CredentialLockerId', 'location' => 'uri', 'locationName' => 'Identifier', ], ], ], 'DeleteDestinationRequest' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'DestinationName', 'location' => 'uri', 'locationName' => 'Name', ], ], ], 'DeleteEventLogConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'LogConfigurationId', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'DeleteLocalStoreAfterUpload' => [ 'type' => 'boolean', 'box' => true, ], 'DeleteManagedThingRequest' => [ 'type' => 'structure', 'required' => [ 'Identifier', ], 'members' => [ 'Identifier' => [ 'shape' => 'ManagedThingId', 'location' => 'uri', 'locationName' => 'Identifier', ], 'Force' => [ 'shape' => 'Boolean', 'location' => 'querystring', 'locationName' => 'Force', ], ], ], 'DeleteNotificationConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'EventType', ], 'members' => [ 'EventType' => [ 'shape' => 'EventType', 'location' => 'uri', 'locationName' => 'EventType', ], ], ], 'DeleteOtaTaskConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'Identifier', ], 'members' => [ 'Identifier' => [ 'shape' => 'OtaTaskConfigurationId', 'location' => 'uri', 'locationName' => 'Identifier', ], ], ], 'DeleteOtaTaskRequest' => [ 'type' => 'structure', 'required' => [ 'Identifier', ], 'members' => [ 'Identifier' => [ 'shape' => 'OtaTaskId', 'location' => 'uri', 'locationName' => 'Identifier', ], ], ], 'DeleteProvisioningProfileRequest' => [ 'type' => 'structure', 'required' => [ 'Identifier', ], 'members' => [ 'Identifier' => [ 'shape' => 'ProvisioningProfileId', 'location' => 'uri', 'locationName' => 'Identifier', ], ], ], 'DeliveryDestinationArn' => [ 'type' => 'string', 'max' => 2048, 'min' => 20, 'pattern' => 'arn:aws:[0-9a-zA-Z]+:[0-9a-zA-Z-]+:[0-9]+:[0-9a-zA-Z]+/[0-9a-zA-Z._-]+', ], 'DeliveryDestinationRoleArn' => [ 'type' => 'string', ], 'DeliveryDestinationType' => [ 'type' => 'string', 'enum' => [ 'KINESIS', ], ], 'DestinationCreatedAt' => [ 'type' => 'timestamp', ], 'DestinationDescription' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '[0-9A-Za-z_\\- ]+', ], 'DestinationListDefinition' => [ 'type' => 'list', 'member' => [ 'shape' => 'DestinationSummary', ], ], 'DestinationName' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[\\p{L}\\p{N} ._-]+', ], 'DestinationSummary' => [ 'type' => 'structure', 'members' => [ 'Description' => [ 'shape' => 'DestinationDescription', ], 'DeliveryDestinationArn' => [ 'shape' => 'DeliveryDestinationArn', ], 'DeliveryDestinationType' => [ 'shape' => 'DeliveryDestinationType', ], 'Name' => [ 'shape' => 'DestinationName', ], 'RoleArn' => [ 'shape' => 'DeliveryDestinationRoleArn', ], ], ], 'DestinationUpdatedAt' => [ 'type' => 'timestamp', ], 'DeviceDiscoveryArn' => [ 'type' => 'string', 'pattern' => 'arn:aws:iotmanagedintegrations:[0-9a-zA-Z-]+:[0-9]+:device-discovery/[0-9a-zA-Z]+', ], 'DeviceDiscoveryId' => [ 'type' => 'string', 'max' => 200, 'min' => 1, 'pattern' => '[A-Za-z0-9]+', ], 'DeviceDiscoveryStatus' => [ 'type' => 'string', 'enum' => [ 'RUNNING', 'SUCCEEDED', 'FAILED', 'TIMED_OUT', ], ], 'DeviceSpecificKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[a-zA-Z0-9=_.,@\\+\\-]+', 'sensitive' => true, ], 'DeviceType' => [ 'type' => 'string', 'max' => 256, 'min' => 0, 'pattern' => '[a-zA-Z0-9=_. ,@\\+\\-/]+', ], 'DeviceTypes' => [ 'type' => 'list', 'member' => [ 'shape' => 'DeviceType', ], 'max' => 50, 'min' => 0, ], 'DisconnectReasonValue' => [ 'type' => 'string', 'enum' => [ 'AUTH_ERROR', 'CLIENT_INITIATED_DISCONNECT', 'CLIENT_ERROR', 'CONNECTION_LOST', 'DUPLICATE_CLIENTID', 'FORBIDDEN_ACCESS', 'MQTT_KEEP_ALIVE_TIMEOUT', 'SERVER_ERROR', 'SERVER_INITIATED_DISCONNECT', 'THROTTLED', 'WEBSOCKET_TTL_EXPIRATION', 'CUSTOMAUTH_TTL_EXPIRATION', 'UNKNOWN', 'NONE', ], ], 'DiscoveryAuthMaterialString' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[0-9A-Za-z_\\-\\+=\\/:; ]+', 'sensitive' => true, ], 'DiscoveryAuthMaterialType' => [ 'type' => 'string', 'enum' => [ 'ZWAVE_INSTALL_CODE', ], ], 'DiscoveryFinishedAt' => [ 'type' => 'timestamp', ], 'DiscoveryStartedAt' => [ 'type' => 'timestamp', ], 'DiscoveryType' => [ 'type' => 'string', 'enum' => [ 'ZWAVE', 'ZIGBEE', 'CLOUD', ], ], 'DurationInMinutes' => [ 'type' => 'integer', 'box' => true, 'max' => 1430, 'min' => 1, ], 'EncryptionType' => [ 'type' => 'string', 'enum' => [ 'MANAGED_INTEGRATIONS_DEFAULT_ENCRYPTION', 'CUSTOMER_KEY_ENCRYPTION', ], ], 'EndTime' => [ 'type' => 'string', ], 'EndpointAddress' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '[A-Za-z0-9._@-]+', ], 'EndpointId' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[0-9a-zA-Z]+', ], 'ErrorMessage' => [ 'type' => 'string', ], 'EventLogConfigurationListDefinition' => [ 'type' => 'list', 'member' => [ 'shape' => 'EventLogConfigurationSummary', ], ], 'EventLogConfigurationSummary' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'LogConfigurationId', ], 'ResourceType' => [ 'shape' => 'SmartHomeResourceType', ], 'ResourceId' => [ 'shape' => 'SmartHomeResourceId', ], 'EventLogLevel' => [ 'shape' => 'LogLevel', ], ], ], 'EventName' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[/a-zA-Z0-9\\._ ]+', ], 'EventType' => [ 'type' => 'string', 'enum' => [ 'DEVICE_COMMAND', 'DEVICE_COMMAND_REQUEST', 'DEVICE_EVENT', 'DEVICE_LIFE_CYCLE', 'DEVICE_STATE', 'DEVICE_OTA', 'CONNECTOR_ASSOCIATION', 'CONNECTOR_ERROR_REPORT', ], ], 'ExecutionNumber' => [ 'type' => 'long', 'box' => true, ], 'ExponentialRolloutRate' => [ 'type' => 'structure', 'members' => [ 'BaseRatePerMinute' => [ 'shape' => 'BaseRatePerMinute', ], 'IncrementFactor' => [ 'shape' => 'IncrementFactor', ], 'RateIncreaseCriteria' => [ 'shape' => 'RolloutRateIncreaseCriteria', ], ], ], 'GetCredentialLockerRequest' => [ 'type' => 'structure', 'required' => [ 'Identifier', ], 'members' => [ 'Identifier' => [ 'shape' => 'CredentialLockerId', 'location' => 'uri', 'locationName' => 'Identifier', ], ], ], 'GetCredentialLockerResponse' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'CredentialLockerId', ], 'Arn' => [ 'shape' => 'CredentialLockerArn', ], 'Name' => [ 'shape' => 'CredentialLockerName', ], 'CreatedAt' => [ 'shape' => 'CredentialLockerCreatedAt', ], 'Tags' => [ 'shape' => 'TagsMap', ], ], ], 'GetCustomEndpointRequest' => [ 'type' => 'structure', 'members' => [], ], 'GetCustomEndpointResponse' => [ 'type' => 'structure', 'required' => [ 'EndpointAddress', ], 'members' => [ 'EndpointAddress' => [ 'shape' => 'EndpointAddress', ], ], ], 'GetDefaultEncryptionConfigurationRequest' => [ 'type' => 'structure', 'members' => [], ], 'GetDefaultEncryptionConfigurationResponse' => [ 'type' => 'structure', 'required' => [ 'configurationStatus', 'encryptionType', ], 'members' => [ 'configurationStatus' => [ 'shape' => 'ConfigurationStatus', ], 'encryptionType' => [ 'shape' => 'EncryptionType', ], 'kmsKeyArn' => [ 'shape' => 'KmsKeyArn', ], ], ], 'GetDestinationRequest' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'DestinationName', 'location' => 'uri', 'locationName' => 'Name', ], ], ], 'GetDestinationResponse' => [ 'type' => 'structure', 'members' => [ 'Description' => [ 'shape' => 'DestinationDescription', ], 'DeliveryDestinationArn' => [ 'shape' => 'DeliveryDestinationArn', ], 'DeliveryDestinationType' => [ 'shape' => 'DeliveryDestinationType', ], 'Name' => [ 'shape' => 'DestinationName', ], 'RoleArn' => [ 'shape' => 'DeliveryDestinationRoleArn', ], 'CreatedAt' => [ 'shape' => 'DestinationCreatedAt', ], 'UpdatedAt' => [ 'shape' => 'DestinationUpdatedAt', ], 'Tags' => [ 'shape' => 'TagsMap', ], ], ], 'GetDeviceDiscoveryRequest' => [ 'type' => 'structure', 'required' => [ 'Identifier', ], 'members' => [ 'Identifier' => [ 'shape' => 'DeviceDiscoveryId', 'location' => 'uri', 'locationName' => 'Identifier', ], ], ], 'GetDeviceDiscoveryResponse' => [ 'type' => 'structure', 'required' => [ 'Id', 'Arn', 'DiscoveryType', 'Status', 'StartedAt', ], 'members' => [ 'Id' => [ 'shape' => 'DeviceDiscoveryId', ], 'Arn' => [ 'shape' => 'DeviceDiscoveryArn', ], 'DiscoveryType' => [ 'shape' => 'DiscoveryType', ], 'Status' => [ 'shape' => 'DeviceDiscoveryStatus', ], 'StartedAt' => [ 'shape' => 'DiscoveryStartedAt', ], 'ControllerId' => [ 'shape' => 'ManagedThingId', ], 'ConnectorAssociationId' => [ 'shape' => 'ConnectorAssociationId', ], 'FinishedAt' => [ 'shape' => 'DiscoveryFinishedAt', ], 'Tags' => [ 'shape' => 'TagsMap', ], ], ], 'GetEventLogConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'Id', ], 'members' => [ 'Id' => [ 'shape' => 'LogConfigurationId', 'location' => 'uri', 'locationName' => 'Id', ], ], ], 'GetEventLogConfigurationResponse' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'LogConfigurationId', ], 'ResourceType' => [ 'shape' => 'SmartHomeResourceType', ], 'ResourceId' => [ 'shape' => 'SmartHomeResourceId', ], 'EventLogLevel' => [ 'shape' => 'LogLevel', ], ], ], 'GetHubConfigurationRequest' => [ 'type' => 'structure', 'members' => [], ], 'GetHubConfigurationResponse' => [ 'type' => 'structure', 'members' => [ 'HubTokenTimerExpirySettingInSeconds' => [ 'shape' => 'HubTokenTimerExpirySettingInSeconds', ], 'UpdatedAt' => [ 'shape' => 'HubConfigurationUpdatedAt', ], ], ], 'GetManagedThingCapabilitiesRequest' => [ 'type' => 'structure', 'required' => [ 'Identifier', ], 'members' => [ 'Identifier' => [ 'shape' => 'ManagedThingId', 'location' => 'uri', 'locationName' => 'Identifier', ], ], ], 'GetManagedThingCapabilitiesResponse' => [ 'type' => 'structure', 'members' => [ 'ManagedThingId' => [ 'shape' => 'ManagedThingId', ], 'Capabilities' => [ 'shape' => 'Capabilities', ], 'CapabilityReport' => [ 'shape' => 'CapabilityReport', ], ], ], 'GetManagedThingConnectivityDataRequest' => [ 'type' => 'structure', 'required' => [ 'Identifier', ], 'members' => [ 'Identifier' => [ 'shape' => 'ManagedThingId', 'location' => 'uri', 'locationName' => 'Identifier', ], ], ], 'GetManagedThingConnectivityDataResponse' => [ 'type' => 'structure', 'members' => [ 'ManagedThingId' => [ 'shape' => 'ManagedThingId', ], 'Connected' => [ 'shape' => 'ConnectivityStatus', ], 'Timestamp' => [ 'shape' => 'ConnectivityTimestamp', ], 'DisconnectReason' => [ 'shape' => 'DisconnectReasonValue', ], ], ], 'GetManagedThingMetaDataRequest' => [ 'type' => 'structure', 'required' => [ 'Identifier', ], 'members' => [ 'Identifier' => [ 'shape' => 'ManagedThingId', 'location' => 'uri', 'locationName' => 'Identifier', ], ], ], 'GetManagedThingMetaDataResponse' => [ 'type' => 'structure', 'members' => [ 'ManagedThingId' => [ 'shape' => 'ManagedThingId', ], 'MetaData' => [ 'shape' => 'MetaData', ], ], ], 'GetManagedThingRequest' => [ 'type' => 'structure', 'required' => [ 'Identifier', ], 'members' => [ 'Identifier' => [ 'shape' => 'ManagedThingId', 'location' => 'uri', 'locationName' => 'Identifier', ], ], ], 'GetManagedThingResponse' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'ManagedThingId', ], 'Arn' => [ 'shape' => 'ManagedThingArn', ], 'Owner' => [ 'shape' => 'Owner', ], 'CredentialLockerId' => [ 'shape' => 'CredentialLockerId', ], 'AdvertisedProductId' => [ 'shape' => 'AdvertisedProductId', ], 'Role' => [ 'shape' => 'Role', ], 'ProvisioningStatus' => [ 'shape' => 'ProvisioningStatus', ], 'Name' => [ 'shape' => 'Name', ], 'Model' => [ 'shape' => 'Model', ], 'Brand' => [ 'shape' => 'Brand', ], 'SerialNumber' => [ 'shape' => 'SerialNumber', ], 'UniversalProductCode' => [ 'shape' => 'UniversalProductCode', ], 'InternationalArticleNumber' => [ 'shape' => 'InternationalArticleNumber', ], 'ConnectorPolicyId' => [ 'shape' => 'ConnectorPolicyId', ], 'ConnectorDeviceId' => [ 'shape' => 'ConnectorDeviceId', ], 'DeviceSpecificKey' => [ 'shape' => 'DeviceSpecificKey', ], 'MacAddress' => [ 'shape' => 'MacAddress', ], 'ParentControllerId' => [ 'shape' => 'ParentControllerId', ], 'Classification' => [ 'shape' => 'Classification', ], 'CreatedAt' => [ 'shape' => 'CreatedAt', ], 'UpdatedAt' => [ 'shape' => 'UpdatedAt', ], 'ActivatedAt' => [ 'shape' => 'SetupAt', ], 'HubNetworkMode' => [ 'shape' => 'HubNetworkMode', ], 'MetaData' => [ 'shape' => 'MetaData', ], 'Tags' => [ 'shape' => 'TagsMap', ], ], ], 'GetManagedThingStateRequest' => [ 'type' => 'structure', 'required' => [ 'ManagedThingId', ], 'members' => [ 'ManagedThingId' => [ 'shape' => 'ManagedThingId', 'location' => 'uri', 'locationName' => 'ManagedThingId', ], ], ], 'GetManagedThingStateResponse' => [ 'type' => 'structure', 'required' => [ 'Endpoints', ], 'members' => [ 'Endpoints' => [ 'shape' => 'StateEndpoints', ], ], ], 'GetNotificationConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'EventType', ], 'members' => [ 'EventType' => [ 'shape' => 'EventType', 'location' => 'uri', 'locationName' => 'EventType', ], ], ], 'GetNotificationConfigurationResponse' => [ 'type' => 'structure', 'members' => [ 'EventType' => [ 'shape' => 'EventType', ], 'DestinationName' => [ 'shape' => 'DestinationName', ], 'CreatedAt' => [ 'shape' => 'NotificationConfigurationCreatedAt', ], 'UpdatedAt' => [ 'shape' => 'NotificationConfigurationUpdatedAt', ], 'Tags' => [ 'shape' => 'TagsMap', ], ], ], 'GetOtaTaskConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'Identifier', ], 'members' => [ 'Identifier' => [ 'shape' => 'OtaTaskConfigurationId', 'location' => 'uri', 'locationName' => 'Identifier', ], ], ], 'GetOtaTaskConfigurationResponse' => [ 'type' => 'structure', 'members' => [ 'TaskConfigurationId' => [ 'shape' => 'OtaTaskConfigurationId', ], 'Name' => [ 'shape' => 'OtaTaskConfigurationName', ], 'PushConfig' => [ 'shape' => 'PushConfig', ], 'Description' => [ 'shape' => 'OtaDescription', ], 'CreatedAt' => [ 'shape' => 'CreatedAt', ], ], ], 'GetOtaTaskRequest' => [ 'type' => 'structure', 'required' => [ 'Identifier', ], 'members' => [ 'Identifier' => [ 'shape' => 'OtaTaskId', 'location' => 'uri', 'locationName' => 'Identifier', ], ], ], 'GetOtaTaskResponse' => [ 'type' => 'structure', 'members' => [ 'TaskId' => [ 'shape' => 'OtaTaskId', ], 'TaskArn' => [ 'shape' => 'OtaTaskArn', ], 'Description' => [ 'shape' => 'OtaDescription', ], 'S3Url' => [ 'shape' => 'S3Url', ], 'Protocol' => [ 'shape' => 'OtaProtocol', ], 'OtaType' => [ 'shape' => 'OtaType', ], 'OtaTargetQueryString' => [ 'shape' => 'OtaTargetQueryString', ], 'OtaMechanism' => [ 'shape' => 'OtaMechanism', ], 'Target' => [ 'shape' => 'Target', ], 'CreatedAt' => [ 'shape' => 'CreatedAt', ], 'LastUpdatedAt' => [ 'shape' => 'LastUpdatedAt', ], 'TaskConfigurationId' => [ 'shape' => 'OtaTaskConfigurationId', ], 'TaskProcessingDetails' => [ 'shape' => 'TaskProcessingDetails', ], 'OtaSchedulingConfig' => [ 'shape' => 'OtaTaskSchedulingConfig', ], 'OtaTaskExecutionRetryConfig' => [ 'shape' => 'OtaTaskExecutionRetryConfig', ], 'Status' => [ 'shape' => 'OtaStatus', ], ], ], 'GetProvisioningProfileRequest' => [ 'type' => 'structure', 'required' => [ 'Identifier', ], 'members' => [ 'Identifier' => [ 'shape' => 'ProvisioningProfileId', 'location' => 'uri', 'locationName' => 'Identifier', ], ], ], 'GetProvisioningProfileResponse' => [ 'type' => 'structure', 'members' => [ 'Arn' => [ 'shape' => 'ProvisioningProfileArn', ], 'Name' => [ 'shape' => 'ProvisioningProfileName', ], 'ProvisioningType' => [ 'shape' => 'ProvisioningType', ], 'Id' => [ 'shape' => 'ProvisioningProfileId', ], 'ClaimCertificate' => [ 'shape' => 'ClaimCertificate', ], 'Tags' => [ 'shape' => 'TagsMap', ], ], ], 'GetRuntimeLogConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'ManagedThingId', ], 'members' => [ 'ManagedThingId' => [ 'shape' => 'ManagedThingId', 'location' => 'uri', 'locationName' => 'ManagedThingId', ], ], ], 'GetRuntimeLogConfigurationResponse' => [ 'type' => 'structure', 'members' => [ 'ManagedThingId' => [ 'shape' => 'ManagedThingId', ], 'RuntimeLogConfigurations' => [ 'shape' => 'RuntimeLogConfigurations', ], ], ], 'GetSchemaVersionRequest' => [ 'type' => 'structure', 'required' => [ 'Type', 'SchemaVersionedId', ], 'members' => [ 'Type' => [ 'shape' => 'SchemaVersionType', 'location' => 'uri', 'locationName' => 'Type', ], 'SchemaVersionedId' => [ 'shape' => 'SchemaVersionedId', 'location' => 'uri', 'locationName' => 'SchemaVersionedId', ], 'Format' => [ 'shape' => 'SchemaVersionFormat', 'location' => 'querystring', 'locationName' => 'Format', ], ], ], 'GetSchemaVersionResponse' => [ 'type' => 'structure', 'members' => [ 'SchemaId' => [ 'shape' => 'SchemaId', ], 'Type' => [ 'shape' => 'SchemaVersionType', ], 'Description' => [ 'shape' => 'SchemaVersionDescription', ], 'Namespace' => [ 'shape' => 'SchemaVersionNamespaceName', ], 'SemanticVersion' => [ 'shape' => 'SchemaVersionVersion', ], 'Visibility' => [ 'shape' => 'SchemaVersionVisibility', ], 'Schema' => [ 'shape' => 'SchemaVersionSchema', ], ], ], 'HubConfigurationUpdatedAt' => [ 'type' => 'timestamp', ], 'HubNetworkMode' => [ 'type' => 'string', 'enum' => [ 'STANDARD', 'NETWORK_WIDE_EXCLUSION', ], ], 'HubTokenTimerExpirySettingInSeconds' => [ 'type' => 'long', 'box' => true, 'min' => 1, ], 'InProgressTimeoutInMinutes' => [ 'type' => 'long', 'box' => true, 'max' => 10080, 'min' => 1, ], 'IncrementFactor' => [ 'type' => 'double', 'box' => true, 'max' => 5, 'min' => 1.1, ], 'Integer' => [ 'type' => 'integer', 'box' => true, ], 'InternalFailureException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, ], 'InternalServerException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, 'fault' => true, ], 'InternationalArticleNumber' => [ 'type' => 'string', 'max' => 13, 'min' => 8, 'pattern' => '[0-9]+', 'sensitive' => true, ], 'KmsKeyArn' => [ 'type' => 'string', 'max' => 200, 'min' => 1, 'pattern' => 'arn:aws:kms:[0-9a-zA-Z-]+:[0-9]+:key/[0-9a-zA-Z-]+', ], 'LastUpdatedAt' => [ 'type' => 'timestamp', ], 'ListCredentialLockersRequest' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'MaxResults', ], ], ], 'ListCredentialLockersResponse' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'CredentialLockerListDefinition', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListDestinationsRequest' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'MaxResults', ], ], ], 'ListDestinationsResponse' => [ 'type' => 'structure', 'members' => [ 'DestinationList' => [ 'shape' => 'DestinationListDefinition', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListEventLogConfigurationsRequest' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'MaxResults', ], ], ], 'ListEventLogConfigurationsResponse' => [ 'type' => 'structure', 'members' => [ 'EventLogConfigurationList' => [ 'shape' => 'EventLogConfigurationListDefinition', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListManagedThingSchemasRequest' => [ 'type' => 'structure', 'required' => [ 'Identifier', ], 'members' => [ 'Identifier' => [ 'shape' => 'ManagedThingId', 'location' => 'uri', 'locationName' => 'Identifier', ], 'EndpointIdFilter' => [ 'shape' => 'EndpointId', 'location' => 'querystring', 'locationName' => 'EndpointIdFilter', ], 'CapabilityIdFilter' => [ 'shape' => 'CapabilityId', 'location' => 'querystring', 'locationName' => 'CapabilityIdFilter', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'MaxResults', ], ], ], 'ListManagedThingSchemasResponse' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'ManagedThingSchemaListDefinition', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListManagedThingsRequest' => [ 'type' => 'structure', 'members' => [ 'OwnerFilter' => [ 'shape' => 'Owner', 'location' => 'querystring', 'locationName' => 'OwnerFilter', ], 'CredentialLockerFilter' => [ 'shape' => 'CredentialLockerId', 'location' => 'querystring', 'locationName' => 'CredentialLockerFilter', ], 'RoleFilter' => [ 'shape' => 'Role', 'location' => 'querystring', 'locationName' => 'RoleFilter', ], 'ParentControllerIdentifierFilter' => [ 'shape' => 'ParentControllerId', 'location' => 'querystring', 'locationName' => 'ParentControllerIdentifierFilter', ], 'ConnectorPolicyIdFilter' => [ 'shape' => 'ConnectorPolicyId', 'location' => 'querystring', 'locationName' => 'ConnectorPolicyIdFilter', ], 'SerialNumberFilter' => [ 'shape' => 'SerialNumber', 'location' => 'querystring', 'locationName' => 'SerialNumberFilter', ], 'ProvisioningStatusFilter' => [ 'shape' => 'ProvisioningStatus', 'location' => 'querystring', 'locationName' => 'ProvisioningStatusFilter', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'MaxResults', ], ], ], 'ListManagedThingsResponse' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'ManagedThingListDefinition', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListNotificationConfigurationsRequest' => [ 'type' => 'structure', 'members' => [ 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'MaxResults', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'NextToken', ], ], ], 'ListNotificationConfigurationsResponse' => [ 'type' => 'structure', 'members' => [ 'NotificationConfigurationList' => [ 'shape' => 'NotificationConfigurationListDefinition', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListOtaTaskConfigurationsRequest' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'MaxResults', ], ], ], 'ListOtaTaskConfigurationsResponse' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'OtaTaskConfigurationListDefinition', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListOtaTaskExecutionsRequest' => [ 'type' => 'structure', 'required' => [ 'Identifier', ], 'members' => [ 'Identifier' => [ 'shape' => 'OtaTaskId', 'location' => 'uri', 'locationName' => 'Identifier', ], 'NextToken' => [ 'shape' => 'OtaNextToken', 'location' => 'querystring', 'locationName' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'MaxResults', ], ], ], 'ListOtaTaskExecutionsResponse' => [ 'type' => 'structure', 'members' => [ 'ExecutionSummaries' => [ 'shape' => 'OtaTaskExecutionSummariesListDefinition', ], 'NextToken' => [ 'shape' => 'OtaNextToken', ], ], ], 'ListOtaTasksRequest' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'OtaNextToken', 'location' => 'querystring', 'locationName' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'MaxResults', ], ], ], 'ListOtaTasksResponse' => [ 'type' => 'structure', 'members' => [ 'Tasks' => [ 'shape' => 'OtaTaskListDefinition', ], 'NextToken' => [ 'shape' => 'OtaNextToken', ], ], ], 'ListProvisioningProfilesRequest' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'MaxResults', ], ], ], 'ListProvisioningProfilesResponse' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'ProvisioningProfileListDefinition', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'ListSchemaVersionsRequest' => [ 'type' => 'structure', 'required' => [ 'Type', ], 'members' => [ 'Type' => [ 'shape' => 'SchemaVersionType', 'location' => 'uri', 'locationName' => 'Type', ], 'MaxResults' => [ 'shape' => 'MaxResults', 'location' => 'querystring', 'locationName' => 'MaxResults', ], 'NextToken' => [ 'shape' => 'NextToken', 'location' => 'querystring', 'locationName' => 'NextToken', ], 'SchemaId' => [ 'shape' => 'SchemaId', 'location' => 'querystring', 'locationName' => 'SchemaIdFilter', ], 'Namespace' => [ 'shape' => 'SchemaVersionNamespaceName', 'location' => 'querystring', 'locationName' => 'NamespaceFilter', ], 'Visibility' => [ 'shape' => 'SchemaVersionVisibility', 'location' => 'querystring', 'locationName' => 'VisibilityFilter', ], 'SemanticVersion' => [ 'shape' => 'SchemaVersionVersion', 'location' => 'querystring', 'locationName' => 'SemanticVersionFilter', ], ], ], 'ListSchemaVersionsResponse' => [ 'type' => 'structure', 'members' => [ 'Items' => [ 'shape' => 'SchemaVersionList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'LocalStoreFileRotationMaxBytes' => [ 'type' => 'integer', 'box' => true, ], 'LocalStoreFileRotationMaxFiles' => [ 'type' => 'integer', 'box' => true, ], 'LocalStoreLocation' => [ 'type' => 'string', ], 'LogConfigurationId' => [ 'type' => 'string', 'max' => 200, 'min' => 1, 'pattern' => '[A-Za-z0-9]+', ], 'LogLevel' => [ 'type' => 'string', 'enum' => [ 'DEBUG', 'ERROR', 'INFO', 'WARN', ], ], 'MacAddress' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'sensitive' => true, ], 'ManagedThingArn' => [ 'type' => 'string', 'max' => 1011, 'min' => 32, 'pattern' => 'arn:aws:iotmanagedintegrations:[0-9a-zA-Z-]+:[0-9]+:managed-thing/([0-9a-zA-Z:_-])+', ], 'ManagedThingId' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[a-zA-Z0-9:_-]*', ], 'ManagedThingListDefinition' => [ 'type' => 'list', 'member' => [ 'shape' => 'ManagedThingSummary', ], ], 'ManagedThingSchemaListDefinition' => [ 'type' => 'list', 'member' => [ 'shape' => 'ManagedThingSchemaListItem', ], ], 'ManagedThingSchemaListItem' => [ 'type' => 'structure', 'members' => [ 'EndpointId' => [ 'shape' => 'EndpointId', ], 'CapabilityId' => [ 'shape' => 'CapabilityId', ], 'Schema' => [ 'shape' => 'ValidationSchema', ], ], ], 'ManagedThingSummary' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'ManagedThingId', ], 'Arn' => [ 'shape' => 'ManagedThingArn', ], 'AdvertisedProductId' => [ 'shape' => 'AdvertisedProductId', ], 'Brand' => [ 'shape' => 'Brand', ], 'Classification' => [ 'shape' => 'Classification', ], 'ConnectorDeviceId' => [ 'shape' => 'ConnectorDeviceId', ], 'ConnectorPolicyId' => [ 'shape' => 'ConnectorPolicyId', ], 'Model' => [ 'shape' => 'Model', ], 'Name' => [ 'shape' => 'Name', ], 'Owner' => [ 'shape' => 'Owner', ], 'CredentialLockerId' => [ 'shape' => 'CredentialLockerId', ], 'ParentControllerId' => [ 'shape' => 'ParentControllerId', ], 'ProvisioningStatus' => [ 'shape' => 'ProvisioningStatus', ], 'Role' => [ 'shape' => 'Role', ], 'SerialNumber' => [ 'shape' => 'SerialNumber', ], 'CreatedAt' => [ 'shape' => 'CreatedAt', ], 'UpdatedAt' => [ 'shape' => 'CreatedAt', ], 'ActivatedAt' => [ 'shape' => 'SetupAt', ], ], ], 'MaxResults' => [ 'type' => 'integer', 'box' => true, 'max' => 1000, 'min' => 1, ], 'MaximumPerMinute' => [ 'type' => 'integer', 'box' => true, 'min' => 1, ], 'MetaData' => [ 'type' => 'map', 'key' => [ 'shape' => 'AttributeName', ], 'value' => [ 'shape' => 'AttributeValue', ], 'max' => 50, 'min' => 1, ], 'MinNumberOfExecutedThings' => [ 'type' => 'integer', 'box' => true, 'max' => 100, 'min' => 1, ], 'MinNumberOfRetries' => [ 'type' => 'integer', 'box' => true, 'max' => 10, 'min' => 0, ], 'Model' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[A-Za-z0-9-_ ]+', 'sensitive' => true, ], 'Name' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[\\p{L}\\p{N} ._-]+', ], 'NextToken' => [ 'type' => 'string', 'max' => 65535, 'min' => 1, 'pattern' => '[a-zA-Z0-9=_-]+', ], 'NodeId' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[a-zA-Z0-9=_.,@\\+\\-/]+', ], 'NotificationConfigurationCreatedAt' => [ 'type' => 'timestamp', ], 'NotificationConfigurationListDefinition' => [ 'type' => 'list', 'member' => [ 'shape' => 'NotificationConfigurationSummary', ], ], 'NotificationConfigurationSummary' => [ 'type' => 'structure', 'members' => [ 'EventType' => [ 'shape' => 'EventType', ], 'DestinationName' => [ 'shape' => 'DestinationName', ], ], ], 'NotificationConfigurationUpdatedAt' => [ 'type' => 'timestamp', ], 'NumberOfNotifiedThings' => [ 'type' => 'integer', 'box' => true, 'max' => 100, 'min' => 1, ], 'NumberOfSucceededThings' => [ 'type' => 'integer', 'box' => true, 'max' => 100, 'min' => 1, ], 'OtaDescription' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '[0-9A-Za-z_\\- ]+', ], 'OtaMechanism' => [ 'type' => 'string', 'enum' => [ 'PUSH', ], ], 'OtaNextToken' => [ 'type' => 'string', 'max' => 65535, 'min' => 1, 'pattern' => '[a-zA-Z0-9=_+/-]+', ], 'OtaProtocol' => [ 'type' => 'string', 'enum' => [ 'HTTP', ], ], 'OtaStatus' => [ 'type' => 'string', 'enum' => [ 'IN_PROGRESS', 'CANCELED', 'COMPLETED', 'DELETION_IN_PROGRESS', 'SCHEDULED', ], ], 'OtaTargetQueryString' => [ 'type' => 'string', ], 'OtaTaskAbortConfig' => [ 'type' => 'structure', 'members' => [ 'AbortConfigCriteriaList' => [ 'shape' => 'AbortConfigCriteriaList', ], ], ], 'OtaTaskArn' => [ 'type' => 'string', 'max' => 1011, 'min' => 0, 'pattern' => 'arn:aws:iotmanagedintegrations:[0-9a-zA-Z-]+:[0-9]+:ota-task/[0-9a-zA-Z]+', ], 'OtaTaskConfigurationId' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[a-zA-Z0-9]*', ], 'OtaTaskConfigurationListDefinition' => [ 'type' => 'list', 'member' => [ 'shape' => 'OtaTaskConfigurationSummary', ], ], 'OtaTaskConfigurationName' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[A-Za-z0-9-_ ]+', 'sensitive' => true, ], 'OtaTaskConfigurationSummary' => [ 'type' => 'structure', 'members' => [ 'TaskConfigurationId' => [ 'shape' => 'OtaTaskConfigurationId', ], 'Name' => [ 'shape' => 'OtaTaskConfigurationName', ], 'CreatedAt' => [ 'shape' => 'CreatedAt', ], ], ], 'OtaTaskExecutionRetryConfig' => [ 'type' => 'structure', 'members' => [ 'RetryConfigCriteria' => [ 'shape' => 'RetryConfigCriteriaList', ], ], ], 'OtaTaskExecutionRolloutConfig' => [ 'type' => 'structure', 'members' => [ 'ExponentialRolloutRate' => [ 'shape' => 'ExponentialRolloutRate', ], 'MaximumPerMinute' => [ 'shape' => 'MaximumPerMinute', ], ], ], 'OtaTaskExecutionStatus' => [ 'type' => 'string', 'enum' => [ 'QUEUED', 'IN_PROGRESS', 'SUCCEEDED', 'FAILED', 'TIMED_OUT', 'REJECTED', 'REMOVED', 'CANCELED', ], ], 'OtaTaskExecutionSummaries' => [ 'type' => 'structure', 'members' => [ 'TaskExecutionSummary' => [ 'shape' => 'OtaTaskExecutionSummary', ], 'ManagedThingId' => [ 'shape' => 'ManagedThingId', ], ], ], 'OtaTaskExecutionSummariesListDefinition' => [ 'type' => 'list', 'member' => [ 'shape' => 'OtaTaskExecutionSummaries', ], ], 'OtaTaskExecutionSummary' => [ 'type' => 'structure', 'members' => [ 'ExecutionNumber' => [ 'shape' => 'ExecutionNumber', ], 'LastUpdatedAt' => [ 'shape' => 'LastUpdatedAt', ], 'QueuedAt' => [ 'shape' => 'QueuedAt', ], 'RetryAttempt' => [ 'shape' => 'RetryAttempt', ], 'StartedAt' => [ 'shape' => 'StartedAt', ], 'Status' => [ 'shape' => 'OtaTaskExecutionStatus', ], ], ], 'OtaTaskId' => [ 'type' => 'string', 'max' => 200, 'min' => 1, 'pattern' => '[A-Za-z0-9]+', ], 'OtaTaskListDefinition' => [ 'type' => 'list', 'member' => [ 'shape' => 'OtaTaskSummary', ], ], 'OtaTaskSchedulingConfig' => [ 'type' => 'structure', 'members' => [ 'EndBehavior' => [ 'shape' => 'SchedulingConfigEndBehavior', ], 'EndTime' => [ 'shape' => 'EndTime', ], 'MaintenanceWindows' => [ 'shape' => 'ScheduleMaintenanceWindowList', ], 'StartTime' => [ 'shape' => 'ScheduleStartTime', ], ], ], 'OtaTaskSummary' => [ 'type' => 'structure', 'members' => [ 'TaskId' => [ 'shape' => 'OtaTaskId', ], 'TaskArn' => [ 'shape' => 'OtaTaskArn', ], 'CreatedAt' => [ 'shape' => 'CreatedAt', ], 'LastUpdatedAt' => [ 'shape' => 'LastUpdatedAt', ], 'TaskConfigurationId' => [ 'shape' => 'OtaTaskConfigurationId', ], 'Status' => [ 'shape' => 'OtaStatus', ], ], ], 'OtaTaskTimeoutConfig' => [ 'type' => 'structure', 'members' => [ 'InProgressTimeoutInMinutes' => [ 'shape' => 'InProgressTimeoutInMinutes', ], ], ], 'OtaType' => [ 'type' => 'string', 'enum' => [ 'ONE_TIME', 'CONTINUOUS', ], ], 'Owner' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[a-zA-Z0-9_.,@-]+', 'sensitive' => true, ], 'ParentControllerId' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[A-Za-z0-9]+', ], 'PropertyName' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[/a-zA-Z0-9\\._ ]+', ], 'ProvisioningProfileArn' => [ 'type' => 'string', 'max' => 64, 'min' => 32, 'pattern' => 'arn:aws:iotmanagedintegrations:[0-9a-zA-Z-]+:[0-9]+:provisioning-profile/[0-9a-zA-Z]+', ], 'ProvisioningProfileId' => [ 'type' => 'string', 'max' => 64, 'min' => 1, 'pattern' => '[A-Za-z0-9-_]+', ], 'ProvisioningProfileListDefinition' => [ 'type' => 'list', 'member' => [ 'shape' => 'ProvisioningProfileSummary', ], ], 'ProvisioningProfileName' => [ 'type' => 'string', 'max' => 36, 'min' => 1, 'pattern' => '[0-9A-Za-z_-]+', ], 'ProvisioningProfileSummary' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'ProvisioningProfileName', ], 'Id' => [ 'shape' => 'ProvisioningProfileId', ], 'Arn' => [ 'shape' => 'ProvisioningProfileArn', ], 'ProvisioningType' => [ 'shape' => 'ProvisioningType', ], ], ], 'ProvisioningStatus' => [ 'type' => 'string', 'enum' => [ 'UNASSOCIATED', 'PRE_ASSOCIATED', 'DISCOVERED', 'ACTIVATED', 'DELETION_FAILED', 'DELETE_IN_PROGRESS', 'ISOLATED', 'DELETED', ], ], 'ProvisioningType' => [ 'type' => 'string', 'enum' => [ 'FLEET_PROVISIONING', 'JITR', ], ], 'PushConfig' => [ 'type' => 'structure', 'members' => [ 'AbortConfig' => [ 'shape' => 'OtaTaskAbortConfig', ], 'RolloutConfig' => [ 'shape' => 'OtaTaskExecutionRolloutConfig', ], 'TimeoutConfig' => [ 'shape' => 'OtaTaskTimeoutConfig', ], ], ], 'PutDefaultEncryptionConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'encryptionType', ], 'members' => [ 'encryptionType' => [ 'shape' => 'EncryptionType', ], 'kmsKeyArn' => [ 'shape' => 'KmsKeyArn', ], ], ], 'PutDefaultEncryptionConfigurationResponse' => [ 'type' => 'structure', 'required' => [ 'configurationStatus', 'encryptionType', ], 'members' => [ 'configurationStatus' => [ 'shape' => 'ConfigurationStatus', ], 'encryptionType' => [ 'shape' => 'EncryptionType', ], 'kmsKeyArn' => [ 'shape' => 'KmsKeyArn', ], ], ], 'PutHubConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'HubTokenTimerExpirySettingInSeconds', ], 'members' => [ 'HubTokenTimerExpirySettingInSeconds' => [ 'shape' => 'HubTokenTimerExpirySettingInSeconds', ], ], ], 'PutHubConfigurationResponse' => [ 'type' => 'structure', 'members' => [ 'HubTokenTimerExpirySettingInSeconds' => [ 'shape' => 'HubTokenTimerExpirySettingInSeconds', ], ], ], 'PutRuntimeLogConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'ManagedThingId', 'RuntimeLogConfigurations', ], 'members' => [ 'ManagedThingId' => [ 'shape' => 'ManagedThingId', 'location' => 'uri', 'locationName' => 'ManagedThingId', ], 'RuntimeLogConfigurations' => [ 'shape' => 'RuntimeLogConfigurations', ], ], ], 'QueuedAt' => [ 'type' => 'timestamp', ], 'RegisterCustomEndpointRequest' => [ 'type' => 'structure', 'members' => [], ], 'RegisterCustomEndpointResponse' => [ 'type' => 'structure', 'required' => [ 'EndpointAddress', ], 'members' => [ 'EndpointAddress' => [ 'shape' => 'EndpointAddress', ], ], ], 'ResetRuntimeLogConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'ManagedThingId', ], 'members' => [ 'ManagedThingId' => [ 'shape' => 'ManagedThingId', 'location' => 'uri', 'locationName' => 'ManagedThingId', ], ], ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 404, 'senderFault' => true, ], 'exception' => true, ], 'RetryAttempt' => [ 'type' => 'integer', 'box' => true, ], 'RetryConfigCriteria' => [ 'type' => 'structure', 'members' => [ 'FailureType' => [ 'shape' => 'RetryCriteriaFailureType', ], 'MinNumberOfRetries' => [ 'shape' => 'MinNumberOfRetries', ], ], ], 'RetryConfigCriteriaList' => [ 'type' => 'list', 'member' => [ 'shape' => 'RetryConfigCriteria', ], ], 'RetryCriteriaFailureType' => [ 'type' => 'string', 'enum' => [ 'FAILED', 'TIMED_OUT', 'ALL', ], ], 'Role' => [ 'type' => 'string', 'enum' => [ 'CONTROLLER', 'DEVICE', ], ], 'RolloutRateIncreaseCriteria' => [ 'type' => 'structure', 'members' => [ 'numberOfNotifiedThings' => [ 'shape' => 'NumberOfNotifiedThings', ], 'numberOfSucceededThings' => [ 'shape' => 'NumberOfSucceededThings', ], ], ], 'RuntimeLogConfigurations' => [ 'type' => 'structure', 'members' => [ 'LogLevel' => [ 'shape' => 'LogLevel', ], 'LogFlushLevel' => [ 'shape' => 'LogLevel', ], 'LocalStoreLocation' => [ 'shape' => 'LocalStoreLocation', ], 'LocalStoreFileRotationMaxFiles' => [ 'shape' => 'LocalStoreFileRotationMaxFiles', ], 'LocalStoreFileRotationMaxBytes' => [ 'shape' => 'LocalStoreFileRotationMaxBytes', ], 'UploadLog' => [ 'shape' => 'UploadLog', ], 'UploadPeriodMinutes' => [ 'shape' => 'UploadPeriodMinutes', ], 'DeleteLocalStoreAfterUpload' => [ 'shape' => 'DeleteLocalStoreAfterUpload', ], ], ], 'S3Url' => [ 'type' => 'string', 'max' => 1000, 'min' => 1, ], 'ScheduleMaintenanceWindow' => [ 'type' => 'structure', 'members' => [ 'DurationInMinutes' => [ 'shape' => 'DurationInMinutes', ], 'StartTime' => [ 'shape' => 'StartTime', ], ], ], 'ScheduleMaintenanceWindowList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ScheduleMaintenanceWindow', ], ], 'ScheduleStartTime' => [ 'type' => 'string', ], 'SchedulingConfigEndBehavior' => [ 'type' => 'string', 'enum' => [ 'STOP_ROLLOUT', 'CANCEL', 'FORCE_CANCEL', ], ], 'SchemaId' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[a-zA-Z0-9./]+', ], 'SchemaVersionDescription' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '[a-zA-Z0-9., ]+', ], 'SchemaVersionFormat' => [ 'type' => 'string', 'enum' => [ 'AWS', 'ZCL', 'CONNECTOR', ], ], 'SchemaVersionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SchemaVersionListItem', ], ], 'SchemaVersionListItem' => [ 'type' => 'structure', 'members' => [ 'SchemaId' => [ 'shape' => 'SchemaId', ], 'Type' => [ 'shape' => 'SchemaVersionType', ], 'Description' => [ 'shape' => 'SchemaVersionDescription', ], 'Namespace' => [ 'shape' => 'SchemaVersionNamespaceName', ], 'SemanticVersion' => [ 'shape' => 'SchemaVersionVersion', ], 'Visibility' => [ 'shape' => 'SchemaVersionVisibility', ], ], ], 'SchemaVersionNamespaceName' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '[a-z]+', ], 'SchemaVersionSchema' => [ 'type' => 'structure', 'members' => [], 'document' => true, ], 'SchemaVersionType' => [ 'type' => 'string', 'enum' => [ 'capability', 'definition', ], ], 'SchemaVersionVersion' => [ 'type' => 'string', 'max' => 256, 'min' => 1, 'pattern' => '(\\d+\\.\\d+|\\$latest)', ], 'SchemaVersionVisibility' => [ 'type' => 'string', 'enum' => [ 'PUBLIC', 'PRIVATE', ], ], 'SchemaVersionedId' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[a-zA-Z0-9.\\/]+(@(\\d+\\.\\d+|\\$latest))?', ], 'SendManagedThingCommandRequest' => [ 'type' => 'structure', 'required' => [ 'ManagedThingId', 'Endpoints', ], 'members' => [ 'ManagedThingId' => [ 'shape' => 'ManagedThingId', 'location' => 'uri', 'locationName' => 'ManagedThingId', ], 'Endpoints' => [ 'shape' => 'CommandEndpoints', ], 'ConnectorAssociationId' => [ 'shape' => 'ConnectorAssociationId', ], ], ], 'SendManagedThingCommandResponse' => [ 'type' => 'structure', 'members' => [ 'TraceId' => [ 'shape' => 'TraceId', ], ], ], 'SerialNumber' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[A-Za-z0-9-_ ]+', 'sensitive' => true, ], 'ServiceQuotaExceededException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 402, 'senderFault' => true, ], 'exception' => true, ], 'ServiceUnavailableException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 503, ], 'exception' => true, 'fault' => true, ], 'SetupAt' => [ 'type' => 'timestamp', ], 'SmartHomeResourceId' => [ 'type' => 'string', 'max' => 200, 'min' => 1, 'pattern' => '[a-zA-Z0-9+*]*', ], 'SmartHomeResourceType' => [ 'type' => 'string', 'pattern' => '[*]$|^(managed-thing|credential-locker|provisioning-profile|ota-task)', ], 'StartDeviceDiscoveryRequest' => [ 'type' => 'structure', 'required' => [ 'DiscoveryType', ], 'members' => [ 'DiscoveryType' => [ 'shape' => 'DiscoveryType', ], 'ControllerIdentifier' => [ 'shape' => 'ManagedThingId', ], 'ConnectorAssociationIdentifier' => [ 'shape' => 'ConnectorAssociationId', ], 'AuthenticationMaterial' => [ 'shape' => 'DiscoveryAuthMaterialString', ], 'AuthenticationMaterialType' => [ 'shape' => 'DiscoveryAuthMaterialType', ], 'ClientToken' => [ 'shape' => 'ClientToken', ], 'Tags' => [ 'shape' => 'TagsMap', ], ], ], 'StartDeviceDiscoveryResponse' => [ 'type' => 'structure', 'members' => [ 'Id' => [ 'shape' => 'DeviceDiscoveryId', ], 'StartedAt' => [ 'shape' => 'DiscoveryStartedAt', ], ], ], 'StartTime' => [ 'type' => 'string', ], 'StartedAt' => [ 'type' => 'timestamp', ], 'StateCapabilities' => [ 'type' => 'list', 'member' => [ 'shape' => 'StateCapability', ], 'max' => 5, 'min' => 1, ], 'StateCapability' => [ 'type' => 'structure', 'required' => [ 'id', 'name', 'version', ], 'members' => [ 'id' => [ 'shape' => 'SchemaVersionedId', ], 'name' => [ 'shape' => 'CapabilityName', ], 'version' => [ 'shape' => 'CapabilityVersion', ], 'properties' => [ 'shape' => 'CapabilityProperties', ], ], ], 'StateEndpoint' => [ 'type' => 'structure', 'required' => [ 'endpointId', 'capabilities', ], 'members' => [ 'endpointId' => [ 'shape' => 'EndpointId', ], 'capabilities' => [ 'shape' => 'StateCapabilities', ], ], ], 'StateEndpoints' => [ 'type' => 'list', 'member' => [ 'shape' => 'StateEndpoint', ], 'max' => 5, 'min' => 0, ], 'String' => [ 'type' => 'string', ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'TagValue' => [ 'type' => 'string', 'max' => 256, 'min' => 0, ], 'TagsMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'TagKey', ], 'value' => [ 'shape' => 'TagValue', ], 'max' => 50, 'min' => 1, 'sensitive' => true, ], 'Target' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], 'TaskProcessingDetails' => [ 'type' => 'structure', 'members' => [ 'NumberOfCanceledThings' => [ 'shape' => 'Integer', ], 'NumberOfFailedThings' => [ 'shape' => 'Integer', ], 'NumberOfInProgressThings' => [ 'shape' => 'Integer', ], 'numberOfQueuedThings' => [ 'shape' => 'Integer', ], 'numberOfRejectedThings' => [ 'shape' => 'Integer', ], 'numberOfRemovedThings' => [ 'shape' => 'Integer', ], 'numberOfSucceededThings' => [ 'shape' => 'Integer', ], 'numberOfTimedOutThings' => [ 'shape' => 'Integer', ], 'processingTargets' => [ 'shape' => 'Target', ], ], ], 'ThresholdPercentage' => [ 'type' => 'double', 'box' => true, 'max' => 100, ], 'ThrottlingException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 429, 'senderFault' => true, ], 'exception' => true, ], 'TraceId' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '[a-zA-Z0-9:=_-]+', ], 'UnauthorizedException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 401, 'senderFault' => true, ], 'exception' => true, ], 'UniversalProductCode' => [ 'type' => 'string', 'max' => 12, 'min' => 12, 'pattern' => '[0-9]+', 'sensitive' => true, ], 'UpdateDestinationRequest' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'DestinationName', 'location' => 'uri', 'locationName' => 'Name', ], 'DeliveryDestinationArn' => [ 'shape' => 'DeliveryDestinationArn', ], 'DeliveryDestinationType' => [ 'shape' => 'DeliveryDestinationType', ], 'RoleArn' => [ 'shape' => 'DeliveryDestinationRoleArn', ], 'Description' => [ 'shape' => 'DestinationDescription', ], ], ], 'UpdateEventLogConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'Id', 'EventLogLevel', ], 'members' => [ 'Id' => [ 'shape' => 'LogConfigurationId', 'location' => 'uri', 'locationName' => 'Id', ], 'EventLogLevel' => [ 'shape' => 'LogLevel', ], ], ], 'UpdateManagedThingRequest' => [ 'type' => 'structure', 'required' => [ 'Identifier', ], 'members' => [ 'Identifier' => [ 'shape' => 'ManagedThingId', 'location' => 'uri', 'locationName' => 'Identifier', ], 'Owner' => [ 'shape' => 'Owner', ], 'CredentialLockerId' => [ 'shape' => 'CredentialLockerId', ], 'SerialNumber' => [ 'shape' => 'SerialNumber', ], 'Brand' => [ 'shape' => 'Brand', ], 'Model' => [ 'shape' => 'Model', ], 'Name' => [ 'shape' => 'Name', ], 'CapabilityReport' => [ 'shape' => 'CapabilityReport', ], 'Capabilities' => [ 'shape' => 'Capabilities', ], 'Classification' => [ 'shape' => 'Classification', ], 'HubNetworkMode' => [ 'shape' => 'HubNetworkMode', ], 'MetaData' => [ 'shape' => 'MetaData', ], ], ], 'UpdateNotificationConfigurationRequest' => [ 'type' => 'structure', 'required' => [ 'EventType', 'DestinationName', ], 'members' => [ 'EventType' => [ 'shape' => 'EventType', 'location' => 'uri', 'locationName' => 'EventType', ], 'DestinationName' => [ 'shape' => 'DestinationName', ], ], ], 'UpdateOtaTaskRequest' => [ 'type' => 'structure', 'required' => [ 'Identifier', ], 'members' => [ 'Identifier' => [ 'shape' => 'OtaTaskId', 'location' => 'uri', 'locationName' => 'Identifier', ], 'Description' => [ 'shape' => 'OtaDescription', ], 'TaskConfigurationId' => [ 'shape' => 'OtaTaskConfigurationId', ], ], ], 'UpdatedAt' => [ 'type' => 'timestamp', ], 'UploadLog' => [ 'type' => 'boolean', 'box' => true, ], 'UploadPeriodMinutes' => [ 'type' => 'integer', 'box' => true, ], 'ValidationException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, 'senderFault' => true, ], 'exception' => true, ], 'ValidationSchema' => [ 'type' => 'structure', 'members' => [], 'document' => true, ], ],];
